-- XXX: split a lot of this out!
-- XXX2: also uh make some globals for things you use often, like prefs.

-- Profile(pn)
-- This returns a profile, preferably a player one.
-- If there isn't one, we fall back on the machine profile.
local function Profile(pn)
	if PROFILEMAN:IsPersistentProfile(pn) then
		-- player profile
		return PROFILEMAN:GetProfile(pn);
	else
		-- machine profile
		return PROFILEMAN:GetMachineProfile();
	end;
end;

-- PlayerScore(pn)
-- This function gets the top score for a player.
-- The old code that used to be here was absolutely terrible.
local function PlayerScore(pn)
	local s = AutoText("frutiger")..{
		Name="Score"..pn;
		InitCommand=cmd(shadowlength,1;diffuse,PlayerColor(pn);player,pn;Stroke,PlayerMidColor(pn));
		OnCommand=cmd(linear,0.2;diffusealpha,1;queuecommand,"Set");
		OffCommand=cmd(linear,0.2;diffusealpha,0);
		SetCommand=function(self)
			local SongOrCourse, StepsOrTrail;

			local scorelist;
			local text = "";
			local profile;

			if GAMESTATE:IsCourseMode() then
				SongOrCourse = GAMESTATE:GetCurrentCourse();
				StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
			else
				SongOrCourse = GAMESTATE:GetCurrentSong();
				StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
			end;

			if SongOrCourse then
				if StepsOrTrail then
					profile = Profile(pn);
					scorelist = profile:GetHighScoreList(SongOrCourse,StepsOrTrail);
					assert(scorelist);
					local scores = scorelist:GetHighScores();
					local topscore = scores[1];
					if not topscore then
						text = string.format("%.2f%%", 0);
					else
						text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
					end;
				else
					text = string.format("%.2f%%", 0);
				end;
			else
				text = string.format("%.2f%%", 0);
			end;
			self:settext(text);
		end;
		-- song and course changes
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		-- steps and trail changes
		CurrentStepsP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentStepsP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;

		CurrentTrailP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentTrailP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;
	};

	return s;
end;

local t = Def.ActorFrame{
	-- OptionIcons
	Def.ActorFrame{
		Name="OptionIcons";

--[[
		-- stepmania's ModIconRow
		Def.ModIconRow  {
			Name="ModIconRowP1";
			InitCommand=cmd(x,SCREEN_CENTER_X-156;y,SCREEN_CENTER_Y-180);
			BeginCommand=function(self)
				if GAMESTATE:IsHumanPlayer(PLAYER_1) then
					self:visible(true);
				else
					self:visible(false);
				end;
			end;
			OnCommand=cmd(Load,"ModIconRowSelectMusic",PLAYER_1;diffusealpha,0;linear,0.2;diffusealpha,1);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
			PlayerOptionsChangedP1MessageCommand=cmd(set,PLAYER_1);
		};

		Def.ModIconRow  {
			Name="ModIconRowP2";
			InitCommand=cmd(x,SCREEN_CENTER_X-156;y,SCREEN_CENTER_Y+180);
			BeginCommand=function(self)
				if GAMESTATE:IsHumanPlayer(PLAYER_2) then
					self:visible(true);
				else
					self:visible(false);
				end;
			end;
			OnCommand=cmd(Load,"ModIconRowSelectMusic",PLAYER_2;diffusealpha,0;linear,0.2;diffusealpha,1);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
			PlayerOptionsChangedP2MessageCommand=cmd(set,PLAYER_2);
		};
--]]

		-- return of dubaiOne's custom mod icons:
		Def.ActorFrame{
			Name="MoonIconsHolder";
			InitCommand=function(self)
				-- xxx: encapsulate this into a function
				if IsUsingWideScreen() then
					if round(GetScreenAspectRatio(),5) == AspectRatios["SixteenNine"] then
						self:x(SCREEN_CENTER_X*0.36);
					else
						self:x(SCREEN_CENTER_X*0.2875);
					end;
				else
					self:x(SCREEN_CENTER_X*0.145);
				end;
			end;

			LoadActor("moonIcons", PLAYER_1)..{
				InitCommand=cmd(y,SCREEN_CENTER_Y-180;player,PLAYER_1);
				OnCommand=cmd(diffusealpha,0;linear,0.2;diffusealpha,1);
				OffCommand=cmd(linear,0.2;diffusealpha,0);
			};

			LoadActor("moonIcons", PLAYER_2)..{
				InitCommand=cmd(y,SCREEN_CENTER_Y+180;player,PLAYER_2);
				OnCommand=cmd(diffusealpha,0;linear,0.2;diffusealpha,1);
				OffCommand=cmd(linear,0.2;diffusealpha,0);
			};
		};
	};

	-- frame (this belongs in the underlay but it's easier to work with here
	--        since so many objects are placed in it.)

	Def.ActorFrame{
		Name="Frame";
		InitCommand=cmd(x,SCREEN_CENTER_X-156;y,SCREEN_CENTER_Y);

		LoadActor( HDActor("_under") )..{
			Name="Under";
			InitCommand=cmd(diffusealpha,0);
			OnCommand=cmd(linear,0.2;diffusealpha,1);
			OffCommand=cmd(linear,0.2;zoomy,0;diffusealpha,1);
		};

		-- banner section
		Def.ActorFrame{
			Name="BannerSection";
			InitCommand=cmd(y,-102);

			-- stage number
			AutoText("frutiger",true)..{
				InitCommand=cmd(x,-128;y,-54;horizalign,left;diffuse,color("0,0,0,1");shadowlength,0;zoom,0.5);
				-- hide in event mode
				BeginCommand=function(self)
					if PREFSMAN:GetPreference("EventMode") then
						self:visible(false);
					else
						self:visible(true);
						local text = THEME:GetString("Stage",string.sub(GAMESTATE:GetCurrentStage(),7));
						if GAMESTATE:GetCurrentStage() == 'Stage_Final' then
							self:diffuse( color("0.8,0,0,1") );
						else
							self:diffuse( color("0,0,0,1") );
						end;
						self:settext( text );
					end;
				end;
				OffCommand=cmd(linear,0.2;diffusealpha,0);
			};

			-- sort message
			AutoText("frutiger",true)..{
				InitCommand=cmd(x,128;y,-54;horizalign,right;diffuse,color("0,0,0,1");shadowlength,0;zoom,0.5;NoStroke);
				OffCommand=cmd(linear,0.2;diffusealpha,0);
				UpdateCommand=function(self)
					-- change the text based on SortOrder
					local so = GAMESTATE:GetSortOrder();
					if so ~= nil then
						self:settext( SortOrderToLocalizedString(so) );
					end;
				end;
				SortOrderChangedMessageCommand=cmd(playcommand,'Update');
			};

			Def.ActorProxy {
				Name="BannerProxy";
				BeginCommand=function(self)
					local banner = SCREENMAN:GetTopScreen():GetChild('Banner');
					banner:scaletoclipped(256,80);
					self:SetTarget(banner);
				end;
				OffCommand=cmd(linear,0.2;diffusealpha,0);
			};

			-- tween time = either 0.2 or 0.65, depending on what you want.
			--[[
			Def.Quad{
				Name="FlashyJunk";
				InitCommand=cmd(zoomto,256,80;diffusealpha,0;blend,bmAdd);
				ResetCommand=cmd(cropleft,0;cropright,0;fadeleft,0;faderight,0;diffusealpha,0.25);
				NextSongMessageCommand=cmd(stoptweening;playcommand,"Reset";linear,0.65;fadeleft,1;cropleft,1);
				PreviousSongMessageCommand=cmd(stoptweening;playcommand,"Reset";linear,0.65;faderight,1;cropright,1);
			};
			]]

			Def.ActorProxy{
				Name="CDTitleProxy";
				InitCommand=cmd(x,8;y,68);
				BeginCommand=function(self)
					-- load proxy
					local cdtitle = SCREENMAN:GetTopScreen():GetChild('CDTitle');
					self:SetTarget(cdtitle);
				end;
			};

			LoadActor( THEME:GetPathB("","_frame 3x1"), "_bannerframe", 214 ) .. {
				InitCommand=cmd(diffusealpha,0);
				OnCommand=cmd(linear,0.2;diffusealpha,1);
				OffCommand=cmd(linear,0.2;diffusealpha,0);
			};
		};

		-- bpm display
		Def.ActorFrame{
			Name="BPMSection";
			InitCommand=cmd(x,-96;y,-48;horizalign,left;zoom,0.75);
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
			SetCommand=function(self)
				-- check for a song or course. if there isn't one, hide it.
				local song = GAMESTATE:GetCurrentSong();
				local course = GAMESTATE:GetCurrentCourse();

				if song or course then self:visible(true)
				else self:visible(false);
				end;
			end;

			Def.BPMDisplay{
				File=IsHighDefinition() and THEME:GetPathF("",fontAliases['frutiger'].Hires) or THEME:GetPathF("",fontAliases['frutiger'].Lores);
				Name="BPMDisplay";
				InitCommand=cmd(x,-4;horizalign,right;shadowlength,0;NoStroke);
				OnCommand=cmd(stoptweening);
				OffCommand=cmd(linear,0.2;diffusealpha,0);
				SetCommand=function(self)
					-- stepmania 4 alpha 4 crashed on me once in course mode
					-- by messing up with the bpm select. I can't fix this theme-side;
					-- believe me, I tried:
					--[[
					local SongOrCourse;
					if GAMESTATE:IsCourseMode() then
						Trace("[bpmd] IT'S COURSE MODE!");
						 an assertion of
						-- pTrail failed, so...
						if GAMESTATE:GetCurrentTrail( GAMESTATE:GetMasterPlayerNumber() ) then
							Trace("[bpmd] trail!");
							self:SetFromGameState();
						else
							Trace("[bpmd] no trail");
							return;
						end;
					else
						self:SetFromGameState();
					end;
					]]
					self:SetFromGameState();
				end;
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
			};

			AutoText("frutiger")..{
				Name="BPMLabel";
				InitCommand=cmd(horizalign,left;settext,"BPM";shadowlength,0;diffuse,color("#000000");NoStroke);
				OffCommand=cmd(linear,0.2;diffusealpha,0);
			};

			Def.Quad{
				Name="SongHasStops";
				InitCommand=cmd(diffuse,color("0,0,0,1");diffuseupperleft,color("0.75,0.75,0.75,1");zoomto,6,17;x,56;y,1);
				OffCommand=cmd(stoptweening;linear,0.2;diffusealpha,0);
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				SetCommand=function(self)
					local song = GAMESTATE:GetCurrentSong();
					if not song then
						self:stoptweening();
						self:linear(0.2);
						self:diffusealpha(0);
						return;
					end;
					local timing = song:GetTimingData();
					if timing:HasStops() then
						self:stoptweening();
						self:linear(0.2);
						self:diffusealpha(1);
					else
						self:stoptweening();
						self:linear(0.2);
						self:diffusealpha(0);
					end;
				end;
			};
		};

		-- number of stages in a course
		Def.ActorFrame{
			Name="CourseStagesSection";
			InitCommand=cmd(x,16;y,-48;zoom,0.75);
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
			SetCommand=function(self)
				if not GAMESTATE:IsCourseMode() then
					self:visible(false);
					return;
				else
					local course = GAMESTATE:GetCurrentCourse();
					if course then self:visible(true)
					else self:visible(false);
					end;
				end;
			end;

			AutoText("frutiger") .. {
				Name="CourseSongs";
				InitCommand=cmd(shadowlength,0;diffusealpha,0;diffuse,color("#000000");NoStroke);
				OnCommand=cmd(linear,0.2;diffusealpha,1);
				OffCommand=cmd(linear,0.2;diffusealpha,0);

				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");

				SetCommand=function(self)
					if not GAMESTATE:IsCourseMode() then return; end;

					local course = GAMESTATE:GetCurrentCourse();
					local stages;
					if course then
						stages = course:GetEstimatedNumStages();
					else
						stages = "?";
					end;
					local append = course:GetEstimatedNumStages() ~= 1 and "s" or "";
					self:settext( stages.." stage"..append );
				end;
			};
		};

		-- song length
		Def.ActorFrame{
			Name="LengthSection";
			InitCommand=cmd(x,108;y,-48;horizalign,right;zoom,0.75);
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
			SetCommand=function(self)
				-- check for a song or course. if there isn't one, hide it.
				local song = GAMESTATE:GetCurrentSong();
				local course = GAMESTATE:GetCurrentCourse();
				
				if song or course then self:visible(true)
				else self:visible(false);
				end;
			end;

			AutoText("frutiger") .. {
				Name="SongLength";
				InitCommand=cmd(shadowlength,0;diffusealpha,0;diffuse,color("#000000");NoStroke);
				OnCommand=cmd(linear,0.2;diffusealpha,1;playcommand,"Set");
				OffCommand=cmd(linear,0.2;diffusealpha,0);

				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");

				SetCommand=function(self)
					local song;
					local time;

					if GAMESTATE:IsCourseMode() then
						-- pulse takes care of this for us, somehow.
						if GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber()) then
							local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber());
							time = TrailUtil.GetTotalSeconds( trail );
							--[[
							if time then
								local finalText = SecondsToMSSMsMs(time);
								self:settext( string.sub(finalText, 0, string.len(finalText)-3) );
							else
								self:settext( "xx:xx" );
							end;
							]]
						end;
					else
						song = GAMESTATE:GetCurrentSong();
						if song then
							time = song:MusicLengthSeconds();
							self:visible(true);
						else
							self:visible(false);
						end;
					end;

					if time then
						if time == 105.0 then
							-- r21 lol; it seems to work on other songs but
							-- if a song is exactly 1:45 it won't work lol
							self:settext("not 1:45");
						else
							local finalText = SecondsToMSSMsMs(time);
							self:settext( string.sub(finalText, 0, string.len(finalText)-3) );
						end;
					else
						self:settext( "xx:xx" );
					end;
				end;
			};
		};

		-- Autogen
		LoadActor("Autogen",PLAYER_1)..{
			InitCommand=cmd(x,-96;y,-24;horizalign,left);
			BeginCommand=function(self)
				if GAMESTATE:IsHumanPlayer(PLAYER_1) then
					self:visible(true);
				else
					self:visible(false);
				end;
			end;
		};
		LoadActor("Autogen",PLAYER_2)..{
			InitCommand=cmd(x,96;y,-24;horizalign,right);
			BeginCommand=function(self)
				if GAMESTATE:IsHumanPlayer(PLAYER_2) then
					self:visible(true);
				else
					self:visible(false);
				end;
			end;
		};

		-- fallback controller
		Def.Actor{
			InitCommand=function(self)
				if not GetUserPref("SSMusicInfo") then
					-- write fallback
					SetUserPref("SSMusicInfo","PaneDisplay");
				end;
			end;
		};

		-- DifficultyList
		--[[
		LoadActor("difficultylist")..{
			InitCommand=cmd(x,-80);
			BeginCommand=function(self)
				if GetUserPref("SSMusicInfo") == "DifficultyList" and not GAMESTATE:IsCourseMode() then self:visible(true);
				else self:visible(false);
				end;
			end;
		};
		]]

		-- RadarBars
		LoadActor("radarbars")..{
			InitCommand=cmd(x,-80);
			BeginCommand=function(self)
				if GetUserPref("SSMusicInfo") == "RadarBars" and not GAMESTATE:IsCourseMode() then self:visible(true);
				else self:visible(false);
				end;
			end;
		};

		-- PaneDisplay
		LoadActor("panedisplay")..{
			InitCommand=cmd(x,-80;y,4);
			BeginCommand=function(self)
				if GetUserPref("SSMusicInfo") == "PaneDisplay" and not GAMESTATE:IsCourseMode() then self:visible(true);
				else self:visible(false);
				end;
			end;
		};

		-- Course Contents
		LoadActor("coursecontents")..{
			InitCommand=cmd(x,-80);
			BeginCommand=function(self)
				if GAMESTATE:IsCourseMode() then self:visible(true);
				else self:visible(false);
				end;
			end;
		};

		-- RadarBars & PaneDisplay requires difficulties.
		Def.ActorFrame{
			Name="Difficulties";
			InitCommand=cmd(y,128);
			BeginCommand=function(self)
				if GetUserPref("SSMusicInfo") == "RadarBars" or GetUserPref("SSMusicInfo") == "PaneDisplay" then
					self:visible(true);
				else self:visible(false);
				end;
			end;

			LoadActor("PlayerDifficulty", PLAYER_1)..{
				InitCommand=cmd(x,-128;horizalign,left);
			};
			
			LoadActor("PlayerDifficulty", PLAYER_2)..{
				InitCommand=cmd(x,128;horizalign,right);
			};
		};

		-- scores
		Def.ActorFrame{
			Name="ScoresSection";
			InitCommand=cmd(y,150;zoom,0.75);
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
			SetCommand=function(self)
				-- check for a song or course. if there isn't one, hide it.
				local song = GAMESTATE:GetCurrentSong();
				local course = GAMESTATE:GetCurrentCourse();
				
				if song or course then self:visible(true)
				else self:visible(false);
				end;
			end;

			PlayerScore(PLAYER_1)..{
				InitCommand=cmd(x,-172;horizalign,left);
			};

			PlayerScore(PLAYER_2)..{
				InitCommand=cmd(x,172;horizalign,right);
			};
		};

		-- song options
		AutoText("frutiger") .. {
			Name="SongOptions";
			InitCommand=cmd(y,150;playcommand,"Set";zoom,0.5;shadowlength,1;diffusealpha,0;NoStroke);
			OnCommand=cmd(linear,0.2;diffusealpha,1);
			OffCommand=cmd(linear,0.2;diffusealpha,0);

			SetCommand=function(self)
				local sText = GAMESTATE:GetSongOptionsString()
				sText = string.gsub(sText, ", ", "\n")
				self:settext( sText )
				if GAMESTATE:IsAnExtraStage() then
					self:diffuseshift();
					self:effectcolor1( color("1,1,1,1") );
					self:effectcolor2( color("0.8,0.9,1,1") );
					self:effectperiod(3.5);
				end
			end;
			SongOptionsChangedMessageCommand=cmd(playcommand,"Set");
		};
	};

	-- Fade out here; this and the message for the options should appear
	-- over every single object in this screen. The fade is stolen from
	-- Screen cancel because I like how it worked.
	Def.Quad {
		InitCommand=cmd(diffuse,color("#000000");FullScreen;diffusealpha,0);
		OffCommand=cmd(cropbottom,1;fadebottom,.5;linear,0.3;cropbottom,-0.5;diffusealpha,1);
	};

	AutoText("frutiger")..{
		Text="Press &START; for options";
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;vertalign,bottom;NoStroke);
		OnCommand=cmd(visible,false);
		ShowPressStartForOptionsCommand=cmd(visible,true;zoom,1.5;decelerate,1;zoom,1);
		ShowEnteringOptionsCommand=cmd(settext,"Entering Options...";hurrytweening,0.1;sleep,1;accelerate,0.1;zoomy,0);
	};
};
-- due to how decorations works, I have to add these here.
-- XXX: move everything into overlay where it belongs?
t[#t+1] = StandardDecorationFromFileOptional( "Help", "Help" );
t[#t+1] = StandardDecorationFromFile( "Header", "Header" );

return t;